/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestable;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class SmeltableOre
implements IDeliverable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(SmeltableOre.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());
    private static final String NBT_COUNT = "Count";
    private static final String NBT_RESULT = "Result";
    private final int count;
    private ItemStack result;

    public SmeltableOre(int count) {
        this.count = count;
    }

    public SmeltableOre(int count, ItemStack result) {
        this.count = count;
        this.result = result;
    }

    public static CompoundNBT serialize(IFactoryController controller, SmeltableOre ore) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a(NBT_COUNT, ore.count);
        if (!ItemStackUtils.isEmpty(ore.result).booleanValue()) {
            compound.func_218657_a(NBT_RESULT, (INBT)ore.result.serializeNBT());
        }
        return compound;
    }

    public static SmeltableOre deserialize(IFactoryController controller, CompoundNBT compound) {
        int count = compound.func_74762_e(NBT_COUNT);
        ItemStack result = compound.func_150296_c().contains(NBT_RESULT) ? ItemStackUtils.deserializeFromNBT(compound.func_74775_l(NBT_RESULT)) : ItemStackUtils.EMPTY;
        return new SmeltableOre(count, result);
    }

    public static void serialize(IFactoryController controller, PacketBuffer buffer, SmeltableOre input) {
        buffer.writeInt(input.getCount());
        buffer.writeBoolean(ItemStackUtils.isEmpty(input.result) == false);
        if (!ItemStackUtils.isEmpty(input.result).booleanValue()) {
            buffer.func_150788_a(input.result);
        }
    }

    public static SmeltableOre deserialize(IFactoryController controller, PacketBuffer buffer) {
        int count = buffer.readInt();
        ItemStack result = buffer.readBoolean() ? buffer.func_150791_c() : ItemStack.field_190927_a;
        return new SmeltableOre(count, result);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        return ItemStackUtils.IS_SMELTABLE.and(itemStack -> IColonyManager.getInstance().getCompatibilityManager().isOre((ItemStack)itemStack)).test(stack);
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    @Override
    public IDeliverable copyWithCount(int newCount) {
        return new SmeltableOre(newCount);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getMinimumCount() {
        return 1;
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

